'use strict';

angular.module('estates', [])
    .factory('Estate', ['$http', '$rootScope', function($http, $rootScope){
        function Estate(data){
            this.setData(data);
        }

        Estate.prototype = {
            list : []
            ,addPosition: function(){
                this.list.push({
                    id: 0
                    ,item_id: this.id
                    ,round_id: roundId
                    ,price: this.buy_now_price
                });

            }
            ,setData: function(data){
                angular.extend(this, data.item);
                this.list = data.list;

                this.init();
            }
            ,init: function(){

            }
            ,isChanged: function(){
                return (this.list[0].id == 0);
            }
            ,save: function(){
                var scope = this;

                var message = {
                    title: 'Nieruchomości'
                    ,msg: 'Zapisuję dane. Proszę czekać...'
                };

                this.list.forEach(function(item){
                    $rootScope.$broadcast('Message:addMsg', message);

                    $http.post(appDev + '/front/rest/estate', item)
                        .success(function(data){
                            if(data == 'true')
                            {
                                var index = scope.list.indexOf(item);
                                if(index > -1)
                                {
                                    scope.list.splice(index, 1);
                                }
                            }
                            else
                            {
                                item.id = data.id;
                            }
                            $rootScope.$broadcast('Message:delMsg', message);
                        })
                        .error(function(data){
                            console.log('error');
                        });

                })
            }
            ,remove: function(){
                var scope = this;

                var message = {
                    title: 'Nieruchomości'
                    ,msg: 'Zapisuję dane. Proszę czekać...'
                };

                this.list.forEach(function(item){
                    $rootScope.$broadcast('Message:addMsg', message);

                    $http.post(appDev + '/front/rest/estate/remove', item)
                        .success(function(data){
                            if(data == 'true')
                            {

                            }
                            $rootScope.$broadcast('Message:delMsg', message);
                        })
                        .error(function(data){
                            console.log('error');
                        });

                })
            }
            ,isPlace: function(){
                return (this.type.symbol == 'OFFICE' || this.type.symbol == 'DEPOT' || this.type.symbol == 'STOCKROOM');
            }
        }
        return Estate;
    }])
    .factory('EstatesCurrentList', ['$http', '$q', 'Estate', function($http, $q, Estate){

        var EstatesCurrentList = {
            list: []
            ,_isLoadedData: false
            ,_originalLength: 0
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this.list;
                }
                var deferer = $q.defer();
                var scope = this;
                $http.get(appDev + '/front/rest/estate')
                    .success(function(data){
                        scope.setData(data);
                        scope._isLoadedData = true;
                        deferer.resolve(scope.list);
                        scope._originalLength = data.length;
                    })
                ;

                return deferer.promise;
            }
            ,setData: function(data){
                this.list = [];
                data.forEach(function(itemData){
                    this.list.push(new Estate(itemData));
                }, this);
            }
            ,setOriginalLength: function(){
                this._originalLength = this.list.length;
            }
            ,findById: function(id){
                var found = false;
                for(var i = 0; i < this.list.length; i++){
                    if(this.list[i].id == id){
                        found = this.list[i];
                        break;
                    }
                }
                return found;
            }
            ,addItem: function(itemData){
                var item = {
                    item: itemData
                    ,list: [
                        {
                            id: 0
                            ,item_id: itemData.id
                            ,round_id: roundId
                            ,price: itemData.buy_now_price
                        }
                    ]
                }
                var Item = new Estate(item);
                this.list.push(Item);
                return Item;
            }
            ,removeItem: function(itemData){
                for(var i = 0; i < this.list.length; i++)
                {
                    if(this.list[i].id == itemData.id)
                    {
                        this.list.splice(i, 1);
                        break;
                    }
                }

            }
            ,isAnyChanged: function(){
                var isChanged = false;
                if(this._originalLength != this.list.length){
                    return true;
                }

                for(var i = 0; i < this.list.length; i++)
                {
                    if(this.list[i].isChanged())
                    {
                        isChanged = true;
                        break;
                    }
                }
                return isChanged;
            }
            ,isCompanyEstate: function(Estate){
                var isRented = false;
                for(var i = 0; i < this.list.length; i++)
                {
                    if(Estate.id == this.list[i].id){
                        isRented = true;
                        break;
                    }
                }
                return isRented;
            }
        }

        return EstatesCurrentList;
    }])
    .factory('EstatesList', ['$http', '$q', 'Estate', function($http, $q, Estate){

        var EstatesList = {
            list: []
            ,_isLoadedData: false
            ,types: [
                {name: 'Biura', symbol: 'OFFICE'}
                ,{name: 'Hale', symbol: 'DEPOT'}
                ,{name: 'Magazyny', symbol: 'STOCKROOM'}
            ]
            ,setData: function(data){
                this.list = data;
            }
            ,loadData: function(callbackSuccess, callbackError){
                var deferer = $q.defer();
                var scope = this;
                $http.get(appDev + '/front/rest/creator/places')
                    .success(function(data){
                        scope.setData(data);
                        scope._isLoadedData = true;
                        deferer.resolve(scope.list);
                        if(typeof callbackSuccess != 'undefined')
                        {
                            callbackSuccess(data);
                        }
                    })
                    .error(function(data){
                        deferer.reject();
                        if(typeof callbackError != 'undefined')
                        {
                            callbackError(data);
                        }
                    })
                ;

                return deferer.promise;
            }
            ,reload: function(callbackSuccess, callbackError){
                this._isLoadedData = false;
                return this.loadData(callbackSuccess, callbackError);
            }
        }

        return EstatesList;
    }])
;